#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
#include <unordered_set>
using namespace std;
int findMedian(vector<int>& values) {
    sort(values.begin(), values.end());
    return values[values.size() / 2];
}
vector<int> bfs(const vector<vector<int>>& graph, int start) {
    vector<int> reachable;
    unordered_set<int> visited;
    queue<int> q;
    q.push(start);
    visited.insert(start);
    while (!q.empty()) {
        int node = q.front();
        q.pop();
        reachable.push_back(node);

        for (int neighbor : graph[node]) {
            if (visited.find(neighbor) == visited.end()) {
                visited.insert(neighbor);
                q.push(neighbor);
            }
        }
    }
    return reachable;
}
int main() {
    int N, M, Q, P;
    cin >> N >> M >> Q >> P;
    vector<int> A(N);
    for (int i = 0; i < N; ++i) {
        cin >> A[i];
    }
    vector<vector<int>> graph(N + 1);
    for (int i = 0; i < M; ++i) {
        int u, v;
        cin >> u >> v;
        graph[u].push_back(v);
        graph[v].push_back(u);
    }
    int ans_prev = 0;
    vector<int> results;
    for (int i = 0; i < Q; ++i) {
        int a1, b1;
        cin >> a1 >> b1;
        int a = (a1 + ans_prev * P - 1) % N + 1;
        int b = (b1 + ans_prev * P - 1) % N + 1;
        vector<int> reachable = bfs(graph, a);
        vector<int> values;
        for (int node : reachable) {
            values.push_back(A[node - 1]);
        }
        int ans = findMedian(values);
        results.push_back(ans);
        ans_prev = ans;
    }
    for (int res : results) {
        cout << res << "\n";
    }
    return 0;
}